
function AISMN_ThrowWater::OnEnter(%this, %data)
{
   %object = GetThisObject(%data);
   %object.playThread(0, "watertoss");
   %object.unmountImage(2);
   %object.mountImage("waterpail", 2);
   
   startEffect(%object, "douse");
   
   //Get the building component and target
   %target = GetParameterTarget(%data);
   if (%target != 0)
   {
      FaceObject(%data, %target);
      startEffect(%target, "douse");
   }
}

function AISMN_ThrowWater::OnExit(%this, %data)
{
   %object = GetThisObject(%data);
   %object.playThread(0, "root");

   stopEffect(%object, "douse");
   RestoreCharacterOutfit(%data);
}

//EXIT 0: DONE THROWING WATER
function AISMN_ThrowWater::Update(%this, %data)
{
   if (TimeInNode(%data) > 1.5)
   {
      ReturnValue(%data, 0);
      %tar = GetParameterTarget(%data);
      %component = slgQueryInterface(%tar, $CID_BUILDING);
      
      //If the object doesn't exist, it probably burned up.
      if (0 == %tar || 0 == %component)
      {
         ReturnValue(%data, 0);
         return;
      }
      
      //Splash some water on there!
      %component.extinguishFire(1);
      return;
   }
   
   //Stay in this state
   ReturnValue(%data, -1);
}
